#ifndef _TUS_H
#define _TUS_H

#include "UnityNP.h"
#include "Mutex.h"

namespace UnityPlugin
{
	// Structure for returning TUS and TSS data to the scripts.
	struct TusTssData
	{
		int dataSize;
		void* data;
	};

	// Structure for returning a TUS variable.
	struct TusRetrievedVar
	{
		Int64 lastChangedDate;
		Int64 variable;
		Int64 oldVariable;
		int npIDSize;
		const unsigned char* ownerNpID;
		const unsigned char* lastChangeAuthorNpID;
		int hasData;
	};

	PRX_EXPORT bool PrxTUSIsBusy();
	PRX_EXPORT bool PrxTusTssGetLastError(ResultCode* result);
	PRX_EXPORT ErrorCode PrxTUSClearVariablesToSet();
	PRX_EXPORT ErrorCode PrxTUSAddVariableToSet(int slot, Int64 value);
	PRX_EXPORT ErrorCode PrxTUSSetVariables();
	PRX_EXPORT ErrorCode PrxTUSSetVariablesForUser(const unsigned char* npID);
	PRX_EXPORT ErrorCode PrxTUSSetVariablesForVirtualUser(const unsigned char* onlineID);
	PRX_EXPORT ErrorCode PrxTUSModifyVariables();
	PRX_EXPORT ErrorCode PrxTUSModifyVariablesForUser(const unsigned char* npID);
	PRX_EXPORT ErrorCode PrxTUSModifyVariablesForVirtualUser(const unsigned char* onlineID);

	PRX_EXPORT ErrorCode PrxTUSClearVariablesToGet();
	PRX_EXPORT ErrorCode PrxTUSAddVariableToGet(int slot);
	PRX_EXPORT ErrorCode PrxTUSRequestVariables();
	PRX_EXPORT ErrorCode PrxTUSRequestVariablesForUser(const unsigned char* npID);
	PRX_EXPORT ErrorCode PrxTUSRequestVariablesForVirtualUser(const unsigned char* onlineID);
	PRX_EXPORT int PrxTUSGetVariableCount();
	PRX_EXPORT Int64 PrxTUSGetVariableValue(int index);
	PRX_EXPORT ErrorCode PrxTUSGetVariable(int index, TusRetrievedVar* result);

	PRX_EXPORT ErrorCode PrxTUSSetData(int slotId, void* data, int dataSize);
	PRX_EXPORT ErrorCode PrxTUSSetDataForUser(int slotId, void* data, int dataSize, const unsigned char* npID);
	PRX_EXPORT ErrorCode PrxTUSSetDataForVirtualUser(int slotId, void* data, int dataSize, const unsigned char* onlineID);
	PRX_EXPORT ErrorCode PrxTUSRequestData(int slotID);
	PRX_EXPORT ErrorCode PrxTUSRequestDataForUser(int slotID, const unsigned char* npID);
	PRX_EXPORT ErrorCode PrxTUSRequestDataForVirtualUser(int slotID, const unsigned char* onlineID);
	PRX_EXPORT ErrorCode PrxTUSGetData(TusTssData* data);

	PRX_EXPORT bool PrxTSSIsBusy();
	PRX_EXPORT ErrorCode PrxTSSRequestData();
	PRX_EXPORT ErrorCode PrxTSSRequestDataFromSlot(int slot);
	PRX_EXPORT ErrorCode PrxTSSGetData(TusTssData* data);

	class CachedTusTss
	{
		Mutex m_Lock;
		bool m_Busy;
		ResultCode m_LastResult;

		struct Variable
		{
			Variable(int slot, Int64 val)
			{
				slotId = slot;
				value = val;
			}
			int slotId;			// The slot that the variable belongs to.
			Int64 value;		// The TUS variable value.
		};

		std::vector<Variable> m_VariablesToSet;
		std::vector<int32_t> m_VariablesToGet;
		sce::Toolkit::NP::Utilities::Future<std::vector<SceNpTusVariable> > m_TusVarsIn;
		sce::Toolkit::NP::Utilities::Future<sce::Toolkit::NP::TusDataOutput> m_TusDataIn;
		sce::Toolkit::NP::Utilities::Future<sce::Toolkit::NP::TssData> m_TssDataIn;
		int m_TssBufferSize;
		void* m_TssBuffer;

		struct ModifyState
		{
			ModifyState()
			{
				Reset();
			}

			void Reset()
			{
				memset(this, 0, sizeof(ModifyState));
			}

			bool isModifying;
			SceNpId npID;
			bool isVirtualUser;
		};

		ModifyState m_ModifyState;

	public:
		CachedTusTss();
		~CachedTusTss();
		bool ProcessEvent(const sce::Toolkit::NP::Event& event);

		bool IsTusBusy();
		ErrorCode GetLastError() const { return m_LastResult.GetResult(); }
		bool GetLastError(ResultCode* result) const { *result = m_LastResult; return m_LastResult.GetResult() == NP_OK; }
		ErrorCode ClearTusVariablesToSet();
		ErrorCode AddTusVariablesToSet(int slot, Int64 value);
		ErrorCode SetTusVariables(const unsigned char* npID, bool isVirtualUser);
		ErrorCode ModifyTusVariables(const unsigned char* npID, bool isVirtualUser);

		ErrorCode ClearTusVariablesToGet();
		ErrorCode AddTusVariablesToGet(int slot);
		ErrorCode RequestTusVariables(const unsigned char* npID, bool isVirtualUser);
		int GetTusVariableCount();
		Int64 GetTusVariableValue(int index);
		ErrorCode GetTusVariable(int index, TusRetrievedVar* result);

		ErrorCode SetTusData(int slotId, void* data, int dataSize, const unsigned char* npID, bool isVirtualUser);
		ErrorCode RequestTusData(int slotID, const unsigned char* npID, bool isVirtualUser);
		ErrorCode GetTusData(TusTssData* data);

		bool IsTssBusy();
		ErrorCode RequestTssData();
		ErrorCode RequestTssDataFromSlot(int slotID);
		ErrorCode GetTssData(TusTssData* data);
	};

	extern CachedTusTss gTusTss;
}

#endif // _TUS_H
